"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateDuration = updateDuration;
exports.deleteDuration = deleteDuration;
exports.getDuration = getDuration;
const common_service_1 = require("../../service/common.service");
const logger_service_1 = require("../../service/logger.service");
const api_response_1 = require("../../api.response");
const role_entity_1 = __importDefault(require("../../role/entities/role.entity"));
const duration_entity_1 = __importDefault(require("../entities/duration.entity"));
function updateDuration(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { month } = req.body;
        const existingDuration = yield duration_entity_1.default.find();
        try {
            const updatedDuration = yield duration_entity_1.default.findOneAndUpdate({ _id: existingDuration[0]._id }, { $set: { month: month } }, { new: true });
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.duration.durationUpdated, updatedDuration);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while updating duration: ${error}`);
            console.log("Getting error while updating duration :", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
function deleteDuration() {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const existingDuration = yield duration_entity_1.default.find();
            if (!existingDuration || existingDuration.length === 0) {
                throw new Error("No duration records found.");
            }
            const currentDate = new Date();
            const thresholdDate = new Date(currentDate);
            thresholdDate.setMonth(thresholdDate.getMonth() - existingDuration[0].month);
            const rolesToDelete = yield role_entity_1.default.find({
                createdAt: { $lt: thresholdDate },
            });
            for (let role of rolesToDelete) {
                yield role_entity_1.default.findByIdAndDelete(role._id);
            }
            return { message: "Roles deleted successfully." };
        }
        catch (error) {
            if (error.message === "No duration records found.") {
                return { message: "No duration records found. No roles deleted." };
            }
            else {
                logger_service_1.logger.error(`Error while deleting duration: ${error}`);
                throw new Error("Failed to delete roles.");
            }
        }
    });
}
function getDuration(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a;
        const existingDuration = yield duration_entity_1.default.find();
        if (!existingDuration || existingDuration.length === 0) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.noDataAvailable);
        }
        try {
            const duration = yield duration_entity_1.default.findOne({
                _id: (_a = existingDuration[0]) === null || _a === void 0 ? void 0 : _a._id,
            });
            if (!duration) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.duration.durationNotFound);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, duration);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while  get duration by id : ${error}`);
            console.error("Getting error while  get duration by id : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
