"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendFeedback = sendFeedback;
const common_service_1 = require("../../service/common.service");
const api_response_1 = require("../../api.response");
const feedback_entity_1 = __importDefault(require("../entities/feedback.entity"));
const logger_service_1 = require("../../service/logger.service");
function sendFeedback(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const { feedback, rating } = req.body;
            const userInfo = (0, common_service_1.getTokenUserInfo)(req);
            // Check if feedback and rating are provided
            if (!feedback || !rating) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.allFieldsRequired);
            }
            // Check if feedback from this user already exists
            const existingFeedback = yield feedback_entity_1.default.findOne({
                user: userInfo._id,
            });
            if (existingFeedback) {
                // Update existing feedback
                existingFeedback.feedback = feedback;
                existingFeedback.rating = rating;
                const updatedFeedback = yield existingFeedback.save();
                return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.feedback.updated, updatedFeedback);
            }
            else {
                // Save the feedback to the database
                const savedFeedback = yield feedback_entity_1.default.create({
                    feedback,
                    rating,
                    user: userInfo._id,
                });
                // Optionally, send an email notification to the user or admin
                // const emailSent = await sendEmail({
                //   userEmail: userInfo.email,
                //   subject: "Thank you for your feedback",
                //   text: `We have received your feedback: ${savedFeedback.feedback}`,
                //   html: `<p>We have received your feedback: ${savedFeedback.feedback}</p><p>Rating: ${savedFeedback.rating}</p>`,
                // });
                // if (!emailSent) {
                //   return sendMessageResponse(
                //     req,
                //     res,
                //     StatusCode.InternalServerError,
                //     "Error sending feedback confirmation email"
                //   );
                // }
                // Send a success response
                return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Create, api_response_1.messages.feedback.success, savedFeedback);
            }
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while add feeback  : ${error}`);
            console.log("Getting error while add feeback :", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
