"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.inputFile = exports.UPLOAD_TYPE = void 0;
const mongoose_1 = __importDefault(require("mongoose"));
var UPLOAD_TYPE;
(function (UPLOAD_TYPE) {
    UPLOAD_TYPE["FILE"] = "FILE";
    UPLOAD_TYPE["YOUTUBE"] = "YOUTUBE";
    UPLOAD_TYPE["SCREEN_RECORD"] = "SCREEN_RECORD";
})(UPLOAD_TYPE || (exports.UPLOAD_TYPE = UPLOAD_TYPE = {}));
const inputFileSchema = new mongoose_1.default.Schema({
    file: {
        type: [Object],
    },
    batchName: {
        type: String,
        default: null,
    },
    amount: {
        type: Number,
    },
    userId: {
        type: mongoose_1.default.Types.ObjectId,
    },
    // NEW ADDITIONS IN CONTENT PRO
    users: [
        {
            type: mongoose_1.default.Types.ObjectId,
        },
    ],
    owner: {
        type: mongoose_1.default.Types.ObjectId,
    },
    workspaceId: {
        type: mongoose_1.default.Types.ObjectId,
        ref: "Workspace",
    },
    isRecorded: {
        type: Boolean,
        default: false,
    },
    transcriptionId: {
        type: String,
    },
}, {
    timestamps: true,
});
exports.inputFile = mongoose_1.default.model("input-file", inputFileSchema);
