"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.addRole = addRole;
exports.updateRole = updateRole;
exports.getRoles = getRoles;
exports.getAdminRoles = getAdminRoles;
exports.deleteRole = deleteRole;
exports.getRoleById = getRoleById;
const common_service_1 = require("../../service/common.service");
const logger_service_1 = require("../../service/logger.service");
const api_response_1 = require("../../../src/api.response");
const role_entity_1 = __importDefault(require("../entities/role.entity"));
const admin_user_entity_1 = __importDefault(require("../../user/entities/admin-user.entity"));
const mongoose_1 = __importDefault(require("mongoose"));
//============================ Add ROLE ========================/
function addRole(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { roleName, permission, status } = req.body;
        if (!roleName || !permission) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.allFieldsRequired);
        }
        try {
            let userInfo = (0, common_service_1.getTokenUserInfo)(req);
            const existingUser = yield role_entity_1.default.findOne({
                roleName,
                isDeleted: false,
            });
            if (existingUser) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.role.roleExits);
            }
            else {
                const savedRole = yield role_entity_1.default.create({
                    roleName,
                    permission,
                    status,
                    userId: userInfo === null || userInfo === void 0 ? void 0 : userInfo._id,
                });
                return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Create, api_response_1.messages.role.success, savedRole);
            }
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while add role : ${error}`);
            console.log("Getting error while add role : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//============================ Update ROLE ========================/
function updateRole(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { roleName, permission, status, _id } = req.body;
        try {
            let userInfo = (0, common_service_1.getTokenUserInfo)(req);
            const updatedRole = yield role_entity_1.default.findOneAndUpdate({ _id: new mongoose_1.default.Types.ObjectId(_id), isDeleted: false }, { roleName, permission, status, userId: userInfo === null || userInfo === void 0 ? void 0 : userInfo._id }, { new: true });
            if (!updatedRole) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.role.roleNotFound);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.role.roleUpdated, updatedRole);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while update role : ${error}`);
            console.log("Getting error while update role :", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//============================ GET ALL ROLES ========================/
function getRoles(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const query = req.query;
            const { search, page, take, role } = query;
            let searchQuery = {
                roleName: {
                    $nin: ["SUPER_ADMIN"],
                },
                isDeleted: false,
            };
            if (search) {
                searchQuery = {
                    $and: [
                        { roleName: { $nin: ["SUPER_ADMIN"] } },
                        { roleName: new RegExp(search, "i") },
                    ],
                };
            }
            let filters = {};
            if (role)
                filters.role = role;
            const options = {
                searchQuery,
                filter: filters,
                page: parseInt(page) || 1,
                take: parseInt(take) || 10,
            };
            const { data: roles, totalData, page: currentPage, take: perPage, totalPages, prevPage, nextPage, } = yield (0, common_service_1.fetchUsersWithFilterAndPagination)(role_entity_1.default, options);
            if (!roles.length) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.noDataAvailable);
            }
            const rolesWithoutPermission = roles === null || roles === void 0 ? void 0 : roles.map(({ _id, roleName, status, createdAt, updatedAt, __v }) => ({
                _id,
                roleName,
                status,
                createdAt,
                updatedAt,
                __v,
            }));
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, {
                data: rolesWithoutPermission || [],
                pagination: {
                    nextPage,
                    page: currentPage,
                    prevPage,
                    take: perPage,
                    totalData,
                    totalPages,
                },
            });
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while get roles : ${error}`);
            console.log("Getting error while get roles : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//============================ GET ADMIN ROLES ========================/
function getAdminRoles(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const data = yield role_entity_1.default.find({
                roleName: {
                    $nin: ["SUPER_ADMIN"],
                },
                isDeleted: false,
            });
            if (!data.length) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.noDataAvailable);
            }
            const rolesWithoutPermission = data === null || data === void 0 ? void 0 : data.map(({ _id, roleName, status, createdAt, updatedAt, __v }) => ({
                _id,
                roleName,
                status,
                createdAt,
                updatedAt,
                __v,
            }));
            const responseData = {
                data: rolesWithoutPermission || [],
            };
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, responseData);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while get admin roles: ${error}`);
            console.log("Getting error while get admin roles : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//============================ DELETE A ROLE ========================/
function deleteRole(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const id = req.params.id;
            const assignRole = yield admin_user_entity_1.default.find({
                role: new mongoose_1.default.Types.ObjectId(id),
                isDeleted: false,
            });
            if (assignRole.length > 0) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode === null || api_response_1.StatusCode === void 0 ? void 0 : api_response_1.StatusCode.BadRequest, api_response_1.messages.role.usedRole);
            }
            const roleResult = yield role_entity_1.default.findOneAndUpdate({
                _id: new mongoose_1.default.Types.ObjectId(id),
                isDeleted: false,
            }, {
                isDeleted: true,
            });
            return yield (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.role.roleDeleted, roleResult);
        }
        catch (err) {
            console.log("Getting error while deleting a role :", err);
            logger_service_1.logger.error(`Getting error while deleting a role : ${err}`);
            return yield (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.error);
        }
    });
}
//============================ GET ROLE BY ID ========================/
function getRoleById(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const role = yield role_entity_1.default.findOne({
                _id: new mongoose_1.default.Types.ObjectId(req.params.id),
                isDeleted: false,
            });
            if (!role) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.role.roleNotFound);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, role);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while get role : ${error}`);
            console.error("Error fetching user:", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
