"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const auth_1 = require("../middleware/auth");
const companySettings_1 = require("../company-settings/controllers/companySettings");
const upload_1 = require("../middleware/upload");
const companySetting_validator_1 = require("../validators/companySetting.validator");
const checkPermission_1 = require("../middleware/checkPermission");
const companySettingRoute = express_1.default.Router();
companySettingRoute.get("/company-setting", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("companySettings", "isView"), companySettings_1.getCompanySetting);
companySettingRoute.patch("/company-setting", upload_1.companyImage.fields([{ name: "companyImage", maxCount: 1 }]), auth_1.verifyToken, (0, checkPermission_1.checkPermission)("companySettings", "isEdit"), companySetting_validator_1.validateCompanySetting, companySettings_1.updateCompanySetting);
exports.default = companySettingRoute;
