"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const auth_1 = require("../middleware/auth");
const notification_1 = require("../notification/controllers/notification");
const notification_validator_1 = require("../validators/notification.validator");
const notificationRoute = express_1.default.Router();
notificationRoute.post("/add-notification", auth_1.verifyToken, notification_validator_1.validateNotification, notification_1.addNotification);
notificationRoute.patch("/notification", auth_1.verifyToken, notification_validator_1.validateNotification, notification_1.updateNotification);
notificationRoute.get("/notifications", auth_1.verifyToken, notification_1.getNotifications);
notificationRoute.delete("/notification/:id", auth_1.verifyToken, notification_1.deleteNotification);
notificationRoute.get("/notification/:id", auth_1.verifyToken, notification_1.getNotificationById);
exports.default = notificationRoute;
