"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const auth_1 = require("../middleware/auth");
const ticketSubject_1 = require("../ticket-subject/controllers/ticketSubject");
const ticketSubject_validator_1 = require("../validators/ticketSubject.validator");
const checkPermission_1 = require("../middleware/checkPermission");
const ticketSubjectRoute = express_1.default.Router();
ticketSubjectRoute.post("/add-ticket-subject", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("ticketsSubject", "isAdd"), ticketSubject_validator_1.validateTicketSubject, ticketSubject_1.addTicketSubject);
ticketSubjectRoute.patch("/ticket-subject", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("ticketsSubject", "isEdit"), ticketSubject_validator_1.validateTicketSubject, ticketSubject_1.updateTicketSubject);
ticketSubjectRoute.get("/ticket-subjects", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("ticketsSubject", "isView"), ticketSubject_1.getTicketSubjects);
ticketSubjectRoute.delete("/ticket-subject/:id", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("ticketsSubject", "isDelete"), ticketSubject_1.deleteTicketSubject);
ticketSubjectRoute.get("/ticket-subject/:id", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("ticketsSubject", "isView"), ticketSubject_1.getTicketSubjectById);
exports.default = ticketSubjectRoute;
