"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const auth_1 = require("../middleware/auth");
const transcriptionQuality_1 = require("../transcription-quality/controllers/transcriptionQuality");
const transcriptionQuality_validator_1 = require("../validators/transcriptionQuality.validator");
const checkPermission_1 = require("../middleware/checkPermission");
const transcriptionQualityRoute = express_1.default.Router();
transcriptionQualityRoute.post("/add-transcription-quality", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("transcriptionQuality", "isAdd"), transcriptionQuality_validator_1.validateTranscriptionQuality, transcriptionQuality_1.addTranscriptionQuality);
transcriptionQualityRoute.patch("/transcription-quality", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("transcriptionQuality", "isEdit"), transcriptionQuality_validator_1.validateTranscriptionQuality, transcriptionQuality_1.updateTranscriptionQuality);
transcriptionQualityRoute.get("/transcription-qualityes", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("transcriptionQuality", "isView"), transcriptionQuality_1.getTranscriptionQuality);
transcriptionQualityRoute.delete("/transcription-quality/:id", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("transcriptionQuality", "isDelete"), transcriptionQuality_1.deleteTranscriptionQuality);
transcriptionQualityRoute.get("/transcription-quality/:id", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("transcriptionQuality", "isView"), transcriptionQuality_1.getTranscriptionQualityById);
exports.default = transcriptionQualityRoute;
