"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = __importDefault(require("mongoose"));
const utills_1 = require("../../service/utills");
const adminUserSchema = new mongoose_1.default.Schema({
    profileImage: {
        type: String, // Assuming you'll store the path or URL of the image
    },
    userId: {
        type: mongoose_1.default.Types.ObjectId,
        null: false,
        ref: "Users",
    },
    firstName: {
        type: String,
    },
    lastName: {
        type: String,
    },
    fullName: {
        type: String,
    },
    // username: {
    //   type: String,
    //   required: true,
    //   min: 3,
    //   max: 100,
    // },
    email: {
        type: String,
        required: true,
        min: 5,
        max: 255,
    },
    phone: {
        type: String,
        required: true,
    },
    status: {
        type: Boolean,
        required: true,
    },
    role: {
        type: mongoose_1.default.Types.ObjectId,
        null: false,
        ref: "role",
    },
    userType: {
        type: String,
        enum: [utills_1.USER_TYPE.SUPER_ADMIN, utills_1.USER_TYPE.SUB_ADMIN],
        required: true,
    },
    isDeleted: {
        type: Boolean,
        default: false,
    },
});
exports.default = mongoose_1.default.model("admin-user", adminUserSchema);
