"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateNotification = validateNotification;
const joi_1 = __importDefault(require("joi"));
const api_response_1 = require("../../src/api.response");
const utills_1 = require("../service/utills");
const common_service_1 = require("../service/common.service");
const logger_service_1 = require("../service/logger.service");
function validateNotification(req, res, next) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b, _c, _d, _e;
        try {
            const requestField = {
                title: (_a = req === null || req === void 0 ? void 0 : req.body) === null || _a === void 0 ? void 0 : _a.title,
                groupId: (_b = req === null || req === void 0 ? void 0 : req.body) === null || _b === void 0 ? void 0 : _b.groupId,
                userId: (_c = req === null || req === void 0 ? void 0 : req.body) === null || _c === void 0 ? void 0 : _c.userId,
                message: (_d = req === null || req === void 0 ? void 0 : req.body) === null || _d === void 0 ? void 0 : _d.message,
                notificationType: (_e = req === null || req === void 0 ? void 0 : req.body) === null || _e === void 0 ? void 0 : _e.notificationType,
            };
            const schema = joi_1.default.object({
                title: joi_1.default.string()
                    .min(3)
                    .max(100)
                    .required()
                    .messages(api_response_1.validationMessages.title),
                groupId: joi_1.default.string()
                    .regex(/^[0-9a-fA-F]{24}$/)
                    .when("notificationType", {
                    is: utills_1.notification.group_notification,
                    then: joi_1.default.required(),
                })
                    .messages(api_response_1.validationMessages.groupId),
                userId: joi_1.default.string()
                    .regex(/^[0-9a-fA-F]{24}$/)
                    .when("notificationType", {
                    is: utills_1.notification.individual_notification,
                    then: joi_1.default.required(),
                })
                    .messages(api_response_1.validationMessages.userId),
                message: joi_1.default.string()
                    .min(3)
                    .max(500)
                    .required()
                    .messages(api_response_1.validationMessages.message),
                notificationType: joi_1.default.string()
                    .valid(utills_1.notification.group_notification, utills_1.notification.individual_notification, utills_1.notification.all_users)
                    .required()
                    .messages(api_response_1.validationMessages.notificationType),
            }).options({ abortEarly: false });
            const { error } = schema.validate(requestField);
            if (error) {
                const errorMessages = error.details.map((err) => {
                    var _a;
                    return ({
                        field: (_a = err === null || err === void 0 ? void 0 : err.context) === null || _a === void 0 ? void 0 : _a.key,
                        message: err.message.replace(/"/g, ""),
                    });
                });
                console.log("errorMessages", errorMessages);
                return yield (0, common_service_1.sendValidationMessageResponse)(req, res, api_response_1.StatusCode === null || api_response_1.StatusCode === void 0 ? void 0 : api_response_1.StatusCode.BadRequest, errorMessages);
            }
            next();
        }
        catch (error) {
            console.log("Getting error while check notification validation:", error);
            logger_service_1.logger.error(`Getting error while check notification validation : ${error}`);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.error);
        }
    });
}
