"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.io = void 0;
const express_1 = __importDefault(require("express"));
const body_parser_1 = __importDefault(require("body-parser"));
const cors_1 = __importDefault(require("cors"));
const dotenv_1 = __importDefault(require("dotenv"));
const http_1 = __importDefault(require("http"));
const fs_1 = __importDefault(require("fs"));
const mongoose_1 = __importDefault(require("mongoose"));
const route_manager_1 = require("./routes/route-manager");
const logs_1 = require("./logs/controllers/logs");
const socket_1 = require("./socket/socket");
const { Server } = require("socket.io");
dotenv_1.default.config();
try {
    const app = (0, express_1.default)();
    app.use((0, cors_1.default)());
    app.use(body_parser_1.default.json());
    app.use(body_parser_1.default.urlencoded({ extended: true }));
    app.use(express_1.default.urlencoded({ extended: true }));
    app.use(express_1.default.json());
    app.use("/public", express_1.default.static("public"));
    app.use(logs_1.loggerMiddleware);
    const corsOptions = {
        origin: "*", // Allow all origins or specify allowed origins (e.g., ['https://example.com'])
        methods: "GET,HEAD,PUT,PATCH,POST,DELETE",
        allowedHeaders: ["Origin", "Content-Type", "Accept", "Accept-Language"],
    };
    app.use((0, cors_1.default)(corsOptions));
    // Your other middlewares or routes
    app.use(function (req, res, next) {
        next();
    });
    // app.use(function (req: any, res: any, next: any) {
    //   res.header(
    //     "Access-Control-Allow-Headers",
    //     "Origin, Content-Type, Accept",
    //     "Accept-Language"
    //   );
    //   next();
    // });
    //================= DATABASE CONNECTION =================
    const DB_URL = process.env.DB_URL || "";
    mongoose_1.default
        .connect(DB_URL)
        .then(() => {
        console.log("Database connection Successful!");
    })
        .catch((err) => {
        console.log("Error connecting to Mongo", err);
    });
    //================= MAKE DIRECTORY =================
    const seeder = require("./seeder/seeder");
    const cron = require("./utils/cron");
    try {
        const path = "./public/input-file";
        fs_1.default.access(path, (error) => {
            if (error) {
                fs_1.default.mkdir(path, { recursive: true }, (error) => {
                    if (error) {
                        console.log("Getting error while make public directory :", error);
                    }
                });
            }
        });
    }
    catch (error) {
        console.log("Getting error while make public directory :", error);
    }
    //================= DEFINE ROUTES =================
    app.use("/", route_manager_1.routes);
    // Create an HTTP server
    const server = http_1.default.createServer(app);
    const port = process.env.PORT;
    const host = process.env.HOST;
    //=========== SOCKET SERVER FUNCTION =============//
    exports.io = new Server(server, {
        cors: {
            origin: "*",
            methods: ["GET", "POST"],
        },
    });
    (0, socket_1.socketSetUp)(exports.io);
    module.exports = server;
    //================= LISTEN THE APP =================
    server.listen(port, () => {
        if (host == "localhost" || host == "192.168.29.50" || host == "127.0.0.1") {
            console.log(`Server Started on PORT: http://${host}:${port}/`);
        }
        else {
            console.log(`Server Started on PORT: ${host}`);
        }
    });
}
catch (err) {
    console.log("Getting error", err);
}
