"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.industryImage = exports.inputFile = exports.companyImage = exports.userImage = void 0;
const path_1 = __importDefault(require("path"));
const multer_1 = __importDefault(require("multer"));
const logger_service_1 = require("../service/logger.service");
const api_response_1 = require("../api.response");
// GENERAL IMAGE AND VIDEO STORE LOCATION
let storeFiles = multer_1.default.diskStorage({
    destination: function (req, file, cb) {
        cb(null, process.env.IMAGE_DIRECTORY || "public");
    },
    filename: function (req, file, cb) {
        let ext = path_1.default.extname(file.originalname);
        cb(null, Date.now() + ext);
    },
});
function handleFile(req, file, callback) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const imageWhitelist1 = [
                "image/png",
                "image/jpeg",
                "image/jpg",
                "application/msword",
                "application/octet-stream",
                "video/mp4", // Added MP4 MIME type
            ];
            const audioVideo = [
                "video/mp4", // MP4 video
                "audio/mpeg", // MP3 audio
                "audio/wav", // WAV audio
                "audio/ogg", // OGG audio
                "video/ogg", // OGG video
                "video/webm", // WebM video
                "audio/webm", // WebM audio
            ];
            if (file.fieldname == "profileImage") {
                if (!imageWhitelist1.includes(file.mimetype)) {
                    req.isValid = {
                        isValid: false,
                        message: api_response_1.messages.imageValidation1,
                    };
                }
            }
            if (file.fieldname == "companyImage") {
                if (!imageWhitelist1.includes(file.mimetype)) {
                    req.isValid = {
                        isValid: false,
                        message: api_response_1.messages.imageValidation1,
                    };
                }
            }
            if (file.fieldname == "inputFile") {
                if (!audioVideo.includes(file.mimetype)) {
                    req.isValid = {
                        isValid: false,
                        message: api_response_1.messages.imageValidation1,
                    };
                }
            }
            callback(null, true);
        }
        catch (err) {
            console.log("Getting error while handle file in middleware:", err);
            logger_service_1.logger.error(`Getting error while handle file in middleware : ${err}`);
        }
    });
}
let maxSize = 1024 * 1024 * 20; // 20 mb
//============= ADMIN USER HANDLE FILE
exports.userImage = (0, multer_1.default)({
    storage: storeFiles,
    limits: { fileSize: maxSize },
    fileFilter: handleFile,
});
//============= COMPANY IMAGE FILE
exports.companyImage = (0, multer_1.default)({
    storage: storeFiles,
    limits: { fileSize: maxSize },
    fileFilter: handleFile,
});
//============= INPUT FILE
exports.inputFile = (0, multer_1.default)({
    storage: storeFiles,
    limits: { fileSize: maxSize },
    fileFilter: handleFile,
});
//============= INDUSTRY IMAGE
exports.industryImage = (0, multer_1.default)({
    storage: storeFiles,
    limits: { fileSize: maxSize },
    fileFilter: handleFile,
});
