"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const auth_1 = require("../middleware/auth");
const languageSetup_1 = require("../language-setup/controllers/languageSetup");
const language_validator_1 = require("../validators/language.validator");
const checkPermission_1 = require("../middleware/checkPermission");
const languageRoute = express_1.default.Router();
languageRoute.post("/add-language", auth_1.verifyToken, language_validator_1.validateLanguage, (0, checkPermission_1.checkPermission)("languageSetup", "isAdd"), languageSetup_1.addLanguage);
languageRoute.patch("/language", auth_1.verifyToken, language_validator_1.validateLanguage, (0, checkPermission_1.checkPermission)("languageSetup", "isEdit"), languageSetup_1.updateLanguage);
languageRoute.get("/languages", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("languageSetup", "isView"), languageSetup_1.getLanguages);
languageRoute.delete("/language/:id", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("languageSetup", "isDelete"), languageSetup_1.deletelanguage);
languageRoute.get("/language/:id", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("languageSetup", "isView"), languageSetup_1.getLanguageById);
exports.default = languageRoute;
