"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const auth_1 = require("../middleware/auth");
const subscription_1 = require("../subscription/controllers/subscription");
const subscription_validator_1 = require("../validators/subscription.validator");
const checkPermission_1 = require("../middleware/checkPermission");
const subscriptionRoue = express_1.default.Router();
subscriptionRoue.post("/add-subscription", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("subscriptions", "isAdd"), subscription_validator_1.validateSubscription, subscription_1.addSubscription);
subscriptionRoue.patch("/subscription", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("subscriptions", "isEdit"), subscription_validator_1.validateSubscription, subscription_1.updateSubscription);
subscriptionRoue.get("/subscriptions", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("subscriptions", "isView"), subscription_1.getSubscriptions);
subscriptionRoue.delete("/subscription/:id", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("subscriptions", "isDelete"), subscription_1.deleteSubscription);
subscriptionRoue.get("/subscription/:id", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("subscriptions", "isView"), subscription_1.getSubscriptionById);
exports.default = subscriptionRoue;
