"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const user_1 = require("../user/controllers/user");
const auth_1 = require("../middleware/auth");
const upload_1 = require("../middleware/upload");
const checkPermission_1 = require("../middleware/checkPermission");
const file_validator_1 = require("../validators/file.validator");
const auth_validator_1 = require("../validators/auth.validator");
const userRoute = express_1.default.Router();
userRoute.post("/add-user", auth_1.verifyToken, upload_1.userImage.single("profileImage"), file_validator_1.validateFile, auth_validator_1.validateSubAdminUser, user_1.addUser);
userRoute.get("/users", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("users", "isView"), user_1.getUsers);
userRoute.get("/user/:id", auth_1.verifyToken, user_1.getUser);
userRoute.patch("/user", auth_1.verifyToken, upload_1.userImage.single("profileImage"), file_validator_1.validateFile, user_1.updateUser);
userRoute.delete("/user/:id", auth_1.verifyToken, user_1.deleteUser);
userRoute.get("/app-users", auth_1.verifyToken, user_1.getAppUsers);
exports.default = userRoute;
