"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.shareFile = shareFile;
const common_service_1 = require("../../service/common.service");
const logger_service_1 = require("../../service/logger.service");
const api_response_1 = require("../../api.response");
const mongoose_1 = __importDefault(require("mongoose"));
const input_file_entity_1 = require("../../input-file/entities/input-file.entity");
const workspace_entity_1 = __importDefault(require("../../workspace/entities/workspace.entity"));
const socket_1 = require("../../socket/socket");
const users_entity_1 = __importDefault(require("../../user/entities/users.entity"));
const socket_2 = require("../../socket/socket");
//==================== SHARE FILE =========================/
function shareFile(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const { fileId, 
            // userIds,
            emailIds, } = req.body;
            //========== check for valid input file
            let isFile = yield input_file_entity_1.inputFile.findById(fileId);
            if (!isFile) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.inputFile.invalidFile);
            }
            let users = yield users_entity_1.default.find({ email: { $in: emailIds } });
            let userIds = users.map((item) => item._id);
            //==== check for valid users
            let isUser = yield users_entity_1.default.find({ _id: { $in: userIds } });
            if (isUser.length !== userIds.length) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.user.validUserRequired);
            }
            //========= add new user to input file
            let updatedUserArr = [
                ...new Set([
                    ...isFile.users.map((id) => id.toString()),
                    ...userIds.map((id) => new mongoose_1.default.Types.ObjectId(id).toString()),
                ]),
            ].map((id) => new mongoose_1.default.Types.ObjectId(id));
            yield input_file_entity_1.inputFile.findByIdAndUpdate(fileId, {
                users: updatedUserArr,
            }, { new: true });
            //========= add new users to workspace
            let IsWorkspace = yield workspace_entity_1.default.findById(isFile.workspaceId);
            updatedUserArr = [
                ...new Set([
                    ...IsWorkspace.users.map((id) => id.toString()),
                    ...userIds.map((id) => new mongoose_1.default.Types.ObjectId(id).toString()),
                ]),
            ].map((id) => new mongoose_1.default.Types.ObjectId(id));
            yield workspace_entity_1.default.findByIdAndUpdate(IsWorkspace._id, { users: updatedUserArr }, { new: true });
            userIds.forEach((userId) => {
                // =========== fire event for each user
                let socketId = socket_1.userSocketMap[userId.toString()];
                if (socketId) {
                    // const socket = getSocketInstance();
                    const socket = socket_2.io.sockets.sockets.get(socketId);
                    if (socket) {
                        socket.emit("share-file", {
                            message: "File has been shared",
                            data: isFile,
                        });
                    }
                }
            });
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, "File shared successfully.", {});
        }
        catch (error) {
            console.log("Getting error while share file", error);
            logger_service_1.logger.error(`Getting error while share file: ${error}`);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
