"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.addYourRole = addYourRole;
exports.updateYourRole = updateYourRole;
exports.getYourRoles = getYourRoles;
exports.deleteYourRole = deleteYourRole;
exports.getYourRoleById = getYourRoleById;
const common_service_1 = require("../../service/common.service");
const logger_service_1 = require("../../service/logger.service");
const api_response_1 = require("../../api.response");
const your_role_entity_1 = __importDefault(require("../entities/your-role.entity"));
const mongoose_1 = __importStar(require("mongoose"));
//==================== ADD NEW YOURROLE =========================/
function addYourRole(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { name } = req.body;
        if (!name) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.allFieldsRequired);
        }
        try {
            const existingYourRole = yield your_role_entity_1.default.findOne({ name });
            if (existingYourRole) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.yourRole.exists);
            }
            else {
                const newYourRoleData = new your_role_entity_1.default({
                    name,
                });
                const savedYourRoleData = yield newYourRoleData.save();
                return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Create, api_response_1.messages.yourRole.success, savedYourRoleData);
            }
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while add your role : ${error}`);
            console.log("Getting error while add your role : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//==================== UPDATE AN EXISTING YOURROLE =========================/
function updateYourRole(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { name, _id, status } = req.body;
        try {
            if ((0, mongoose_1.isValidObjectId)(_id)) {
                const updatedYourRole = yield your_role_entity_1.default.findOneAndUpdate({ _id: new mongoose_1.default.Types.ObjectId(_id), isDeleted: false }, { name, status }, { new: true });
                if (updatedYourRole) {
                    return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.yourRole.updated, updatedYourRole);
                }
            }
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.yourRole.notFound);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while  update your role : ${error}`);
            console.log("Getting error while  update your role : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//==================== GET ALL YOUR ROLES =========================/
function getYourRoles(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const query = req.query;
            const { search, page, take } = query;
            const searchQuery = search
                ? { name: new RegExp(search, "i") }
                : {};
            const options = {
                searchQuery,
                filter: {},
                page: parseInt(page) || 1,
                take: parseInt(take) || 10,
            };
            const { data: data, totalData, page: currentPage, take: perPage, totalPages, prevPage, nextPage, } = yield (0, common_service_1.fetchUsersWithFilterAndPagination)(your_role_entity_1.default, options);
            if (!data.length) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.noDataAvailable);
            }
            const responseData = {
                data: data || [],
                pagination: {
                    nextPage,
                    page: currentPage,
                    prevPage,
                    take: perPage,
                    totalData,
                    totalPages,
                },
            };
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, responseData);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while fetching Your Roles: ${error}`);
            console.log("Getting error while fetching Your Roles:", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//==================== DELETE A YOURROLE =========================/
function deleteYourRole(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { id } = req.params;
        try {
            if ((0, mongoose_1.isValidObjectId)(id)) {
                let isDeleted = yield your_role_entity_1.default.findOneAndDelete({
                    _id: new mongoose_1.default.Types.ObjectId(id),
                    isDeleted: false,
                });
                if (isDeleted) {
                    return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.yourRole.deleted);
                }
            }
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.yourRole.notFound);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while  delete your role : ${error}`);
            console.log("Getting error while  delete your role : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//==================== GET YOURROLE BY ID =========================/
function getYourRoleById(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            if ((0, mongoose_1.isValidObjectId)(req.params.id)) {
                const yourRole = yield your_role_entity_1.default.findOne({
                    _id: new mongoose_1.default.Types.ObjectId(req.params.id),
                    isDeleted: false,
                });
                if (yourRole) {
                    return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, yourRole);
                }
            }
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.yourRole.notFound);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while  get yourRole by id : ${error}`);
            console.error("Getting error while  get yourRole by id : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
