"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.addWorkspace = addWorkspace;
exports.updateWorkspace = updateWorkspace;
exports.getWorkspaces = getWorkspaces;
exports.deleteWorkspace = deleteWorkspace;
exports.getWorkspaceById = getWorkspaceById;
exports.getWorkspaceSocket = getWorkspaceSocket;
const common_service_1 = require("../../service/common.service");
const logger_service_1 = require("../../service/logger.service");
const api_response_1 = require("../../api.response");
const workspace_entity_1 = __importDefault(require("../entities/workspace.entity"));
const mongoose_1 = __importDefault(require("mongoose"));
//==================== ADD NEW WORKSPACE =========================/
function addWorkspace(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b, _c;
        const { name } = req.body;
        const userId = (_a = req === null || req === void 0 ? void 0 : req.user) === null || _a === void 0 ? void 0 : _a._id;
        if (!name) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.allFieldsRequired);
        }
        try {
            const existingWorkspace = yield workspace_entity_1.default.findOne({
                name,
                owner: new mongoose_1.default.Types.ObjectId(userId),
            });
            if (existingWorkspace) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.workspace.workspaceExists);
            }
            else {
                const newWorkspaceData = new workspace_entity_1.default({
                    name,
                    owner: new mongoose_1.default.Types.ObjectId((_b = req === null || req === void 0 ? void 0 : req.user) === null || _b === void 0 ? void 0 : _b._id),
                    users: [new mongoose_1.default.Types.ObjectId((_c = req === null || req === void 0 ? void 0 : req.user) === null || _c === void 0 ? void 0 : _c._id)],
                });
                const savedWorkspaceData = yield newWorkspaceData.save();
                return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Create, api_response_1.messages.workspace.success, savedWorkspaceData);
            }
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while add workspace : ${error}`);
            console.log("Getting error while add workspace : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//==================== UPDATE AN EXISTING WORKSPACE =========================/
function updateWorkspace(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { _id, name, status } = req.body;
        try {
            const updatedWorkspace = yield workspace_entity_1.default.findOneAndUpdate({ _id: new mongoose_1.default.Types.ObjectId(_id), isDeleted: false }, { name, status }, { new: true });
            if (!updatedWorkspace) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.workspace.workspaceNotFound);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.workspace.workspaceUpdated, updatedWorkspace);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while  update workspace : ${error}`);
            console.log("Getting error while  update workspace : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//==================== GET ALL WORKSPACE =========================/
function getWorkspaces(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a;
        try {
            const query = req.query;
            const { search, page, take } = query;
            const userId = (_a = req === null || req === void 0 ? void 0 : req.user) === null || _a === void 0 ? void 0 : _a._id;
            const searchQuery = search
                ? { title: new RegExp(search, "i") }
                : {};
            const options = {
                searchQuery,
                filter: {
                    users: { $in: [new mongoose_1.default.Types.ObjectId(userId)] },
                },
                page: parseInt(page) || 1,
                take: parseInt(take) || 10,
            };
            const { data: data, totalData, page: currentPage, take: perPage, totalPages, prevPage, nextPage, } = yield (0, common_service_1.fetchUsersWithFilterAndPagination)(workspace_entity_1.default, options);
            if (!data.length) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.noDataAvailable);
            }
            const responseData = {
                data: data || [],
                pagination: {
                    nextPage,
                    page: currentPage,
                    prevPage,
                    take: perPage,
                    totalData,
                    totalPages,
                },
            };
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, responseData);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while fetching workspace: ${error}`);
            console.log("Getting error while fetching workspace:", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//==================== DELETE A WORKSPACE =========================/
function deleteWorkspace(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { id } = req.params;
        try {
            yield workspace_entity_1.default.findOneAndDelete({
                _id: new mongoose_1.default.Types.ObjectId(id),
                isDeleted: false,
            });
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.workspace.workspaceDeleted);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while  delete workspace : ${error}`);
            console.log("Getting error while  delete workspace : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//==================== GET WORKSPACE BY ID =========================/
function getWorkspaceById(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const workspace = yield workspace_entity_1.default.findOne({
                _id: new mongoose_1.default.Types.ObjectId(req.params.id),
                isDeleted: false,
            });
            if (!workspace) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.workspace.workspaceNotFound);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, workspace);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while  get workspace by id : ${error}`);
            console.error("Getting error while  get workspace by id : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
function getWorkspaceSocket(server, userSocketMap, isAdminUserMap, userId) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            //========= find socket id for user
            let socketId = userSocketMap[userId];
            let isAdmin = isAdminUserMap[userId];
            let query = {};
            //======= fetch data accordingly
            if (isAdmin === false || isAdmin === "false") {
                query = {
                    isDeleted: false,
                    $or: [{ owner: userId }, { users: userId }],
                };
            }
            let data = yield workspace_entity_1.default.find(query);
            //====== emit event
            server.to(socketId).emit("get-workspace-list", data);
        }
        catch (error) {
            console.log("Getting error while get workspace socket::", error);
            logger_service_1.logger.error(`Getting error while get workspace socket:: ${error}`);
        }
    });
}
