"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkPermission = void 0;
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
const role_entity_1 = __importDefault(require("../role/entities/role.entity"));
const api_response_1 = require("../api.response");
const logger_service_1 = require("../service/logger.service");
const common_service_1 = require("../service/common.service");
const dotenv_1 = __importDefault(require("dotenv"));
const utills_1 = require("../service/utills");
dotenv_1.default.config();
const secret = process.env.JWT_SECRET || "";
const checkPermission = (resource, action) => {
    return (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
        const authHeader = req.headers["authorization"];
        if (!authHeader) {
            return res
                .status(401)
                .json({ message: "Authorization header is missing" });
        }
        const token = authHeader.split(" ")[1];
        try {
            const decoded = jsonwebtoken_1.default.verify(token, secret);
            const roleId = decoded.roleId;
            const userRole = yield role_entity_1.default.findOne({ _id: roleId });
            if (decoded.userType == utills_1.USER_TYPE.SUB_ADMIN) {
                if (!userRole) {
                    return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.updateUser.userNotFound);
                }
                if (!(userRole === null || userRole === void 0 ? void 0 : userRole.permission[resource])) {
                    return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Unauthorized, api_response_1.messages.insufficient_Permissions);
                }
                else {
                    if ((userRole === null || userRole === void 0 ? void 0 : userRole.permission[resource][action]) === false ||
                        (userRole === null || userRole === void 0 ? void 0 : userRole.permission[resource][action]) === undefined) {
                        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Unauthorized, api_response_1.messages.insufficient_Permissions);
                    }
                }
            }
            req.user = Object.assign(Object.assign({}, req.user), { roleId });
            next();
        }
        catch (error) {
            console.error("JWT verification error:", error);
            logger_service_1.logger.error(`Getting error while check permission user : ${error}`);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Unauthorized, api_response_1.messages.user.invalidToken);
        }
    });
};
exports.checkPermission = checkPermission;
