"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const role_1 = require("../role/controllers/role");
const auth_1 = require("../middleware/auth");
const role_validator_1 = require("../validators/role.validator");
const checkPermission_1 = require("../middleware/checkPermission");
const roleRoute = express_1.default.Router();
roleRoute.post("/add-role", auth_1.verifyToken, role_validator_1.validateRole, (0, checkPermission_1.checkPermission)("roles", "isAdd"), role_1.addRole);
roleRoute.patch("/role", auth_1.verifyToken, role_validator_1.validateRole, (0, checkPermission_1.checkPermission)("roles", "isEdit"), role_1.updateRole);
roleRoute.get("/roles", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("roles", "isView"), role_1.getRoles);
roleRoute.get("/admin-roles", role_1.getAdminRoles);
roleRoute.delete("/role/:id", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("roles", "isDelete"), role_1.deleteRole);
roleRoute.get("/role/:id", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("roles", "isView"), role_1.getRoleById);
exports.default = roleRoute;
