"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const auth_1 = require("../middleware/auth");
const ticket_1 = require("../ticket-management/controllers/ticket");
const ticket_validator_1 = require("../validators/ticket.validator");
const checkPermission_1 = require("../middleware/checkPermission");
const ticketRoute = express_1.default.Router();
ticketRoute.post("/add-ticket", auth_1.verifyToken, ticket_validator_1.validateTicket, (0, checkPermission_1.checkPermission)("ticketsManagement", "isAdd"), ticket_1.addTicket);
ticketRoute.patch("/ticket", auth_1.verifyToken, ticket_validator_1.validateTicket, (0, checkPermission_1.checkPermission)("ticketsManagement", "isEdit"), ticket_1.updateTicket);
ticketRoute.get("/tickets", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("ticketsManagement", "isView"), ticket_1.getTicketes);
ticketRoute.delete("/ticket/:id", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("ticketsManagement", "isDelete"), ticket_1.deleteTicket);
ticketRoute.get("/ticket/:id", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("ticketsManagement", "isView"), ticket_1.getTicketById);
exports.default = ticketRoute;
