"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const auth_1 = require("../middleware/auth");
const transcriptionCategory_1 = require("../transcription-category/controllers/transcriptionCategory");
const transcriptionCategory_validator_1 = require("../validators/transcriptionCategory.validator");
const checkPermission_1 = require("../middleware/checkPermission");
const transcriptionCategoryRoute = express_1.default.Router();
transcriptionCategoryRoute.post("/add-transcription-category", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("transcriptionCategory", "isAdd"), transcriptionCategory_validator_1.validateTranscriptionCategory, transcriptionCategory_1.addTranscriptionCategory);
transcriptionCategoryRoute.patch("/transcription-category", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("transcriptionCategory", "isEdit"), transcriptionCategory_validator_1.validateTranscriptionCategory, transcriptionCategory_1.updateTranscriptionCategory);
transcriptionCategoryRoute.get("/transcription-categorys", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("transcriptionCategory", "isView"), transcriptionCategory_1.getTranscriptionCategoryes);
transcriptionCategoryRoute.delete("/transcription-category/:id", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("transcriptionCategory", "isDelete"), transcriptionCategory_1.deleteTranscriptionCategory);
transcriptionCategoryRoute.get("/transcription-category/:id", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("transcriptionCategory", "isView"), transcriptionCategory_1.getTranscriptionCategoryById);
exports.default = transcriptionCategoryRoute;
