"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const auth_1 = require("../middleware/auth");
const workspace_validator_1 = require("../validators/workspace.validator");
const checkPermission_1 = require("../middleware/checkPermission");
const workspace_1 = require("../workspace/controllers/workspace");
const workspaceRoutes = express_1.default.Router();
workspaceRoutes.post("/add-workspace", auth_1.verifyToken, workspace_validator_1.validateWorkspace, (0, checkPermission_1.checkPermission)("Workspace", "isAdd"), workspace_1.addWorkspace);
workspaceRoutes.patch("/update-workspace", auth_1.verifyToken, workspace_validator_1.validateWorkspace, (0, checkPermission_1.checkPermission)("Workspace", "isEdit"), workspace_1.updateWorkspace);
workspaceRoutes.get("/workspaces", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("Workspace", "isView"), workspace_1.getWorkspaces);
workspaceRoutes.delete("/workspace/:id", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("Workspace", "isDelete"), workspace_1.deleteWorkspace);
workspaceRoutes.get("/workspace/:id", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("Workspace", "isView"), workspace_1.getWorkspaceById);
exports.default = workspaceRoutes;
