"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const role_entity_1 = __importDefault(require("../role/entities/role.entity"));
const company_settings_entity_1 = __importDefault(require("../company-settings/entities/company-settings.entity"));
const admin_user_entity_1 = __importDefault(require("../user/entities/admin-user.entity"));
const users_entity_1 = __importDefault(require("../user/entities/users.entity"));
const utills_1 = require("../service/utills");
const terms_conditions_entity_1 = __importDefault(require("../terms-conditions/entities/terms-conditions.entity"));
const privacy_policy_entity_1 = __importDefault(require("../privacy-policy/entities/privacy-policy.entity"));
const duration_entity_1 = __importDefault(require("../delete-file-duration/entities/duration.entity"));
const roleSeeder = () => __awaiter(void 0, void 0, void 0, function* () {
    const roleCount = yield role_entity_1.default.countDocuments();
    if (roleCount === 0) {
        const roleObject = [
            {
                _id: "658eb48c983b3608bf5036fc",
                roleName: "SUPER_ADMIN",
                userId: "658eadca518a1c3b2af1bd9a",
                permission: {
                    dashboard: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    users: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    roles: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    transcriptionFiles: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    toolUsers: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    subscriptions: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    payments: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    languageSetup: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    transcriptionQuality: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    transcriptionCategory: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    audioPlayback: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    supportFormat: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    outputFormat: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    fileManagement: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    transcriptionPerformance: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    transcriptionTrends: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    trendsStatistics: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    usageStatistics: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    supportRequest: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    supportSubject: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    thematicAnalysis: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    thematicStatistics: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    FAQs: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    ticketsManagement: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    ticketsSubject: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    chat: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    broadcastNotification: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    groupManagement: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    logs: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    companySettings: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    termsAndConditions: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    privacyPolicy: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    profile: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    changePassword: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                    ratingReviewAndTestimonial: {
                        isEdit: true,
                        isDelete: true,
                        isAdd: true,
                        isView: true,
                    },
                },
            },
        ];
        yield role_entity_1.default.create(roleObject);
    }
});
roleSeeder();
const adminUserSeeder = () => __awaiter(void 0, void 0, void 0, function* () {
    const count = yield users_entity_1.default.countDocuments({});
    if (count === 0) {
        const userObject = [
            {
                // Super admin
                _id: "658eadca518a1c3b2af1bd9a",
                profileImage: "",
                userType: utills_1.USER_TYPE.SUPER_ADMIN,
                email: "super.admin@gmail.com",
                phone: 9521245236,
                password: "$2b$10$eWV2m4BGQYdFZGoL/r.aP.WB33yebh41H6zV/JgJCAJazKWUbXRfG",
                role: "658eb48c983b3608bf5036fc",
                status: true,
            },
        ];
        yield users_entity_1.default.create(userObject);
        const adminUserObject = Object.assign(Object.assign({}, userObject[0]), { userId: userObject[0]._id, firstName: "Super", lastName: "Admin", fullName: "Super Admin" });
        yield admin_user_entity_1.default.create(adminUserObject);
    }
});
adminUserSeeder();
const adminCompanySettings = () => __awaiter(void 0, void 0, void 0, function* () {
    const count = yield company_settings_entity_1.default.countDocuments({});
    if (count === 0) {
        const companyObject = [
            {
                // Super admin
                _id: "658eadca518a1c3b2af1bd8a",
                companyName: "Admin Company",
                emailId: "admin.test@gmail.com",
                mobileNumber: 5243152379,
                url: "https://goo.gl/tLl6Dl",
            },
        ];
        yield company_settings_entity_1.default.create(companyObject);
    }
});
adminCompanySettings();
const adminTermsCondition = () => __awaiter(void 0, void 0, void 0, function* () {
    const count = yield terms_conditions_entity_1.default.countDocuments({});
    if (count === 0) {
        const termsConditionObject = [
            {
                // Super admin
                _id: "658eadca518a1c3b2af1bd7a",
                termsCondition: "Test 123",
            },
        ];
        yield terms_conditions_entity_1.default.create(termsConditionObject);
    }
});
adminTermsCondition();
const adminPrivacyPolicy = () => __awaiter(void 0, void 0, void 0, function* () {
    const count = yield privacy_policy_entity_1.default.countDocuments({});
    if (count === 0) {
        const privacyPolicyObject = [
            {
                // Super admin
                _id: "658eadca518a1c3b2af1bd6a",
                privacyPolicy: "Test 123",
            },
        ];
        yield privacy_policy_entity_1.default.create(privacyPolicyObject);
    }
});
adminPrivacyPolicy();
const createDuration = () => __awaiter(void 0, void 0, void 0, function* () {
    const count = yield duration_entity_1.default.countDocuments({});
    if (count === 0) {
        yield duration_entity_1.default.create({
            _id: "658eadca518a1c3b2af1bd6a",
            month: 1,
        });
        console.log("Duration objects created successfully.");
    }
});
createDuration();
