"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTermsCondition = getTermsCondition;
exports.updateTermsCondition = updateTermsCondition;
const common_service_1 = require("../../service/common.service");
const logger_service_1 = require("../../service/logger.service");
const api_response_1 = require("../../../src/api.response");
const terms_conditions_entity_1 = __importDefault(require("../entities/terms-conditions.entity"));
const mongoose_1 = __importDefault(require("mongoose"));
//===================== GET TERMS & CONDITIONS =================//
function getTermsCondition(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const data = yield terms_conditions_entity_1.default.find();
            if (!data.length) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.noDataAvailable);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, data[0]);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while get terms and condition: ${error}`);
            console.log("Getting error while get terms and condition: ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//===================== UPDATE TERMS & CONDITIONS =================//
function updateTermsCondition(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { termsCondition, _id } = req.body;
        try {
            const updatedTermsCondition = yield terms_conditions_entity_1.default.findByIdAndUpdate({ _id: new mongoose_1.default.Types.ObjectId(_id) }, { termsCondition }, { new: true });
            if (!updatedTermsCondition) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.termsCondition.termsConditionNotFound);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.termsCondition.termsConditionUpdated, updatedTermsCondition);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while update terms and condition: ${error}`);
            console.log("Getting error while update terms and condition: ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
