"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.addIndustry = addIndustry;
exports.updateIndustry = updateIndustry;
exports.getIndustries = getIndustries;
exports.deleteIndustry = deleteIndustry;
exports.getIndustryById = getIndustryById;
const common_service_1 = require("../../service/common.service");
const logger_service_1 = require("../../service/logger.service");
const api_response_1 = require("../../api.response");
const industry_entity_1 = __importDefault(require("../entities/industry.entity"));
const mongoose_1 = __importStar(require("mongoose"));
//==================== ADD NEW INDUSTRY =========================/
function addIndustry(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b, _c, _d;
        const { name } = req.body;
        if (!name) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.allFieldsRequired);
        }
        try {
            const existingIndustry = yield industry_entity_1.default.findOne({ name });
            if (existingIndustry) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.industry.exists);
            }
            else {
                let industryImage = ((_a = req === null || req === void 0 ? void 0 : req.body) === null || _a === void 0 ? void 0 : _a.image) || null;
                if ((_b = req === null || req === void 0 ? void 0 : req.files) === null || _b === void 0 ? void 0 : _b.image) {
                    industryImage = (_d = (_c = req === null || req === void 0 ? void 0 : req.files) === null || _c === void 0 ? void 0 : _c.image[0]) === null || _d === void 0 ? void 0 : _d.filename;
                }
                const newIndustryData = new industry_entity_1.default({
                    name,
                    image: industryImage,
                });
                const savedIndustryData = yield newIndustryData.save();
                return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Create, api_response_1.messages.industry.success, savedIndustryData);
            }
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while add industry : ${error}`);
            console.log("Getting error while add industry : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//==================== UPDATE AN EXISTING INDUSTRY =========================/
function updateIndustry(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b, _c, _d;
        const { name, _id, status } = req.body;
        try {
            if ((0, mongoose_1.isValidObjectId)(_id)) {
                let updateObj = {
                    name,
                    status,
                };
                let industryImage = ((_a = req === null || req === void 0 ? void 0 : req.body) === null || _a === void 0 ? void 0 : _a.image) || null;
                if ((_b = req === null || req === void 0 ? void 0 : req.files) === null || _b === void 0 ? void 0 : _b.image) {
                    industryImage = (_d = (_c = req === null || req === void 0 ? void 0 : req.files) === null || _c === void 0 ? void 0 : _c.image[0]) === null || _d === void 0 ? void 0 : _d.filename;
                }
                if (industryImage) {
                    updateObj = Object.assign(Object.assign({}, updateObj), { image: industryImage });
                }
                const updatedIndustry = yield industry_entity_1.default.findOneAndUpdate({ _id: new mongoose_1.default.Types.ObjectId(_id), isDeleted: false }, updateObj, { new: true });
                if (updatedIndustry) {
                    return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.industry.updated, updatedIndustry);
                }
            }
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.industry.notFound);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while  update Industry : ${error}`);
            console.log("Getting error while  update Industry : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//==================== GET ALL INDUSTRIES =========================/
function getIndustries(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const query = req.query;
            const { search, page, take } = query;
            const searchQuery = search
                ? { name: new RegExp(search, "i") }
                : {};
            const options = {
                searchQuery,
                filter: {},
                page: parseInt(page) || 1,
                take: parseInt(take) || 10,
            };
            const { data: data, totalData, page: currentPage, take: perPage, totalPages, prevPage, nextPage, } = yield (0, common_service_1.fetchUsersWithFilterAndPagination)(industry_entity_1.default, options);
            if (!data.length) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.noDataAvailable);
            }
            const responseData = {
                data: data || [],
                pagination: {
                    nextPage,
                    page: currentPage,
                    prevPage,
                    take: perPage,
                    totalData,
                    totalPages,
                },
            };
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, responseData);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while fetching Industries: ${error}`);
            console.log("Getting error while fetching Industries:", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//==================== DELETE A INDUSTRY =========================/
function deleteIndustry(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { id } = req.params;
        try {
            if ((0, mongoose_1.isValidObjectId)(id)) {
                let isDeleted = yield industry_entity_1.default.findOneAndDelete({
                    _id: new mongoose_1.default.Types.ObjectId(id),
                    isDeleted: false,
                });
                if (isDeleted) {
                    return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.industry.deleted);
                }
            }
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.industry.notFound);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while  delete industry : ${error}`);
            console.log("Getting error while  delete industry : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//==================== GET INDUSTRY BY ID =========================/
function getIndustryById(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            if ((0, mongoose_1.isValidObjectId)(req.params.id)) {
                const industry = yield industry_entity_1.default.findOne({
                    _id: new mongoose_1.default.Types.ObjectId(req.params.id),
                    isDeleted: false,
                });
                if (industry) {
                    return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, industry);
                }
            }
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.industry.notFound);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while  get industry by id : ${error}`);
            console.error("Getting error while  get industry by id : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
