"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = __importDefault(require("mongoose"));
const utills_1 = require("../../service/utills");
const appUserSchema = new mongoose_1.default.Schema({
    firstName: {
        type: String,
    },
    lastName: {
        type: String,
    },
    fullName: {
        type: String,
    },
    // username: {
    //   type: String,
    //   required: true,
    //   min: 3,
    //   max: 100,
    // },
    email: {
        type: String,
        required: true,
        min: 5,
        max: 255,
    },
    userId: {
        type: mongoose_1.default.Types.ObjectId,
        null: false,
        ref: "Users",
    },
    profileImage: {
        type: String, // Assuming you'll store the path or URL of the image
    },
    status: {
        type: Boolean,
        default: true,
    },
    userType: {
        type: String,
        enum: [utills_1.USER_TYPE.USER],
        required: true,
    },
    phone: {
        type: Number,
    },
    otp: {
        type: String,
    },
    isVerify: {
        type: Boolean,
        default: false,
    },
    loginCount: {
        type: Number,
        default: 0,
    },
    isDeleted: {
        type: Boolean,
        default: false,
    },
    industry: {
        type: mongoose_1.default.Types.ObjectId,
    },
    yourRoles: [
        {
            type: mongoose_1.default.Types.ObjectId,
        },
    ],
});
exports.default = mongoose_1.default.model("app-user", appUserSchema);
