"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.verifyToken = verifyToken;
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
const dotenv_1 = __importDefault(require("dotenv"));
const users_entity_1 = __importDefault(require("../user/entities/users.entity"));
const api_response_1 = require("../api.response");
const logger_service_1 = require("../service/logger.service");
const common_service_1 = require("../service/common.service");
const auth_token_entity_1 = __importDefault(require("../auth/entities/auth-token.entity"));
const admin_user_entity_1 = __importDefault(require("../user/entities/admin-user.entity"));
const app_user_entity_1 = __importDefault(require("../user/entities/app-user.entity"));
const utills_1 = require("../service/utills");
dotenv_1.default.config();
const secret = process.env.JWT_SECRET || "";
//********** VERIFY TOKEN AND PASS CREDENTIALS IN REQUEST ***************//
function verifyToken(req, res, next) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b, _c, _d, _e;
        try {
            //============== CHECK TOKE INTO HEADERS
            if (((_a = req === null || req === void 0 ? void 0 : req.headers) === null || _a === void 0 ? void 0 : _a.authorization) &&
                ((_c = (_b = req === null || req === void 0 ? void 0 : req.headers) === null || _b === void 0 ? void 0 : _b.authorization) === null || _c === void 0 ? void 0 : _c.split(" ")[0]) === "Bearer") {
                const token = (_e = (_d = req === null || req === void 0 ? void 0 : req.headers) === null || _d === void 0 ? void 0 : _d.authorization) === null || _e === void 0 ? void 0 : _e.split(" ")[1];
                //============== CHECK TOKE INTO DB
                const isValideToken = yield auth_token_entity_1.default.findOne({
                    token: token,
                });
                if (isValideToken === null) {
                    return yield (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Unauthorized, api_response_1.messages.invalid_token);
                }
                try {
                    //============== DECODED TOKEN
                    const decoded = jsonwebtoken_1.default.verify(token, secret);
                    const user = yield users_entity_1.default.findOne({
                        _id: decoded === null || decoded === void 0 ? void 0 : decoded._id,
                    });
                    if (user) {
                        //============== CHECK ADMIN
                        if ((decoded === null || decoded === void 0 ? void 0 : decoded.userType) == utills_1.USER_TYPE.SUPER_ADMIN) {
                            let SUPER_ADMIN = yield admin_user_entity_1.default.findOne({
                                userId: decoded === null || decoded === void 0 ? void 0 : decoded._id,
                            });
                            if (SUPER_ADMIN === null) {
                                return yield (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode === null || api_response_1.StatusCode === void 0 ? void 0 : api_response_1.StatusCode.Unauthorized, api_response_1.messages === null || api_response_1.messages === void 0 ? void 0 : api_response_1.messages.auth_fail_error);
                            }
                            else {
                                req.user = decoded;
                                return next();
                            }
                        }
                        else if ((decoded === null || decoded === void 0 ? void 0 : decoded.userType) === utills_1.USER_TYPE.SUB_ADMIN) {
                            let SUB_ADMIN = yield admin_user_entity_1.default.findOne({
                                userId: decoded === null || decoded === void 0 ? void 0 : decoded._id,
                            });
                            if (SUB_ADMIN === null) {
                                return yield (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode === null || api_response_1.StatusCode === void 0 ? void 0 : api_response_1.StatusCode.Unauthorized, api_response_1.messages === null || api_response_1.messages === void 0 ? void 0 : api_response_1.messages.auth_fail_error);
                            }
                            else {
                                req.user = decoded;
                                return next();
                            }
                        }
                        else if ((decoded === null || decoded === void 0 ? void 0 : decoded.userType) === utills_1.USER_TYPE.USER) {
                            let appUser = yield app_user_entity_1.default.findOne({
                                userId: decoded === null || decoded === void 0 ? void 0 : decoded._id,
                            });
                            if (appUser === null) {
                                return yield (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode === null || api_response_1.StatusCode === void 0 ? void 0 : api_response_1.StatusCode.Unauthorized, api_response_1.messages === null || api_response_1.messages === void 0 ? void 0 : api_response_1.messages.auth_fail_error);
                            }
                            else {
                                req.user = decoded;
                                return next();
                            }
                        }
                        else {
                            return yield (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode === null || api_response_1.StatusCode === void 0 ? void 0 : api_response_1.StatusCode.Unauthorized, api_response_1.messages === null || api_response_1.messages === void 0 ? void 0 : api_response_1.messages.auth_fail_error);
                        }
                    }
                    else {
                        return yield (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode === null || api_response_1.StatusCode === void 0 ? void 0 : api_response_1.StatusCode.Unauthorized, api_response_1.messages === null || api_response_1.messages === void 0 ? void 0 : api_response_1.messages.auth_fail_error);
                    }
                }
                catch (error) {
                    return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.error);
                }
            }
            else {
                console.log("token error");
                return yield (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Unauthorized, api_response_1.messages.invalid_token);
            }
        }
        catch (err) {
            console.log("Getting error while verify access token :", err);
            logger_service_1.logger.error(`Getting error while verify access token: ${err} `);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.error);
        }
    });
}
