"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.verifyjwt = void 0;
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
const mongoose_1 = __importDefault(require("mongoose"));
const api_response_1 = require("../api.response");
const common_service_1 = require("../service/common.service");
const auth_token_entity_1 = __importDefault(require("../auth/entities/auth-token.entity"));
const utills_1 = require("../service/utills");
const verifyjwt = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const authHeader = req.headers["authorization"];
    // Check if the authorization header is present
    if (!authHeader) {
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Unauthorized, api_response_1.messages.unauthorizedUser);
    }
    const token = authHeader.split(" ")[1];
    try {
        const decoded = jsonwebtoken_1.default.verify(token, process.env.JWT_SECRET);
        const userId = new mongoose_1.default.Types.ObjectId(decoded._id);
        const authToken = yield auth_token_entity_1.default.findOne({ userId, token });
        if (!authToken) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Unauthorized, api_response_1.messages.invalidToken);
        }
        if (decoded.userType !== utills_1.USER_TYPE.SUPER_ADMIN && !decoded.status) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Unauthorized, api_response_1.messages.unauthorizedUser);
        }
        req.user = decoded;
        next();
    }
    catch (e) {
        if (e instanceof jsonwebtoken_1.default.JsonWebTokenError) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.invalidToken);
        }
        console.error("Error verifying JWT:", e);
        return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
    }
});
exports.verifyjwt = verifyjwt;
