"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNotificationSocket = void 0;
exports.addNotification = addNotification;
exports.updateNotification = updateNotification;
exports.getNotificationsOld = getNotificationsOld;
exports.getNotifications = getNotifications;
exports.deleteNotification = deleteNotification;
exports.getNotificationById = getNotificationById;
const common_service_1 = require("../../service/common.service");
const logger_service_1 = require("../../service/logger.service");
const utills_1 = require("../../service/utills");
const api_response_1 = require("../../api.response");
const common_service_2 = require("../../service/common.service");
const group_entity_1 = __importDefault(require("../../group/entities/group.entity"));
const app_user_entity_1 = __importDefault(require("../../user/entities/app-user.entity"));
const allUsersNotification_entity_1 = __importDefault(require("../entities/allUsersNotification.entity"));
const notification_entity_1 = __importDefault(require("../entities/notification.entity"));
const mongoose_1 = __importDefault(require("mongoose"));
//===================== ADD NEW NOTIFICATION =====================/
function addNotification(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { title, groupId, userId, message, notificationType } = req.body;
        if (!title || !message || !notificationType) {
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.allFieldsRequired);
        }
        try {
            const existingNotification = yield notification_entity_1.default.findOne({
                title,
                isDeleted: false,
            });
            if (existingNotification) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.BadRequest, api_response_1.messages.notification.notificationExits);
            }
            else {
                const savedNotification = yield notification_entity_1.default.create({
                    title,
                    userId,
                    message,
                    notificationType,
                    groupId,
                });
                yield savedNotification.populate([
                    {
                        path: "userId",
                        select: "username",
                    },
                    {
                        path: "groupId",
                        select: "groupName",
                    },
                ]);
                if (savedNotification) {
                    if (savedNotification.notificationType ==
                        utills_1.notification.individual_notification) {
                        yield allUsersNotification_entity_1.default.create({
                            notificationId: savedNotification._id,
                            userId: savedNotification.userId,
                            isSeen: false,
                        });
                    }
                    else if (savedNotification.notificationType == utills_1.notification.group_notification) {
                        const usersInGroup = yield group_entity_1.default.findOne({
                            _id: groupId,
                            isDeleted: false,
                        });
                        const groupNotifications = usersInGroup.users.map((userId) => ({
                            notificationId: savedNotification._id,
                            userId: userId,
                            isSeen: false,
                        }));
                        yield allUsersNotification_entity_1.default.insertMany(groupNotifications);
                    }
                    else {
                        const allUsers = yield app_user_entity_1.default.find({ isDeleted: false });
                        console.log("allUsers", allUsers);
                        const allUsersNotifications = allUsers.map((item) => ({
                            notificationId: savedNotification._id,
                            userId: item.userId,
                            isSeen: false,
                        }));
                        console.log("allUsersNotifications", allUsersNotifications);
                        yield allUsersNotification_entity_1.default.insertMany(allUsersNotifications);
                    }
                }
                return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Create, api_response_1.messages.notification.success, savedNotification);
            }
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while  add notification : ${error}`);
            console.log("Getting error while  add notification : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//===================== UPDATE AN EXISTING NOTIFICATION ==========/
function updateNotification(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { title, userId, message, notificationType, groupId, _id } = req.body;
        try {
            const updatedNotification = yield notification_entity_1.default.findOneAndUpdate({ _id: new mongoose_1.default.Types.ObjectId(_id), isDeleted: false }, {
                title,
                userId,
                message,
                notificationType,
                groupId,
            }, { new: true });
            if (!updatedNotification) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.notification.notificationNotFound);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.notification.notificationUpdated, updatedNotification);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while  update notification : ${error}`);
            console.log("Getting error while  update notification : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//===================== GET ALL NOTIFICATION =====================/
function getNotificationsOld(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a;
        try {
            let userId;
            let user = req.user;
            userId = req.userType === utills_1.USER_TYPE.USER ? (_a = req.user) === null || _a === void 0 ? void 0 : _a._id : null;
            let data = yield notification_entity_1.default.aggregate([
                {
                    $lookup: {
                        from: "users",
                        localField: "_id",
                        foreignField: userId,
                        as: "userData",
                    },
                },
            ]);
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, "hfhf");
        }
        catch (error) {
            logger_service_1.logger.error(`Error while fetching notifications: ${error}`);
            console.log("Error while fetching notifications:", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//===================== GET ALL NOTIFICATION =====================/
function getNotifications(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const query = req.query;
            const { search, page, take, role } = query;
            let searchQuery = search ? { title: new RegExp(search, "i") } : {};
            let filters = { isDeleted: false };
            if (role)
                filters.role = role;
            const options = {
                searchQuery,
                filter: filters,
                page: parseInt(page) || 1,
                take: parseInt(take) || 10,
            };
            const { data: notifications, totalData, page: currentPage, take: perPage, totalPages, prevPage, nextPage, } = yield (0, common_service_2.fetchUsersWithFilterAndPagination)(notification_entity_1.default, options);
            const populateNotifications = yield notification_entity_1.default.populate(notifications, [
                {
                    path: "userId",
                    select: "username",
                },
                {
                    path: "groupId",
                    select: "groupName",
                },
            ]);
            if (!populateNotifications.length) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.noDataAvailable);
            }
            const responseData = {
                data: populateNotifications || [],
                pagination: {
                    nextPage,
                    page: currentPage,
                    prevPage,
                    take: perPage,
                    totalData,
                    totalPages,
                },
            };
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, responseData);
        }
        catch (error) {
            logger_service_1.logger.error(`Error while fetching notifications: ${error}`);
            console.log("Error while fetching notifications:", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//===================== DELETE ALL NOTIFICATION =====================/
function deleteNotification(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const { id } = req.params;
        try {
            yield notification_entity_1.default.findOneAndUpdate({ _id: new mongoose_1.default.Types.ObjectId(id), isDeleted: false }, { isDeleted: true });
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.notification.notificationDeleted);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while delete notification : ${error}`);
            console.log("Getting error while delete notification : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//================ GET NOTIFICATION BY ID ===================/
function getNotificationById(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const notification = yield notification_entity_1.default.findOne({
                _id: new mongoose_1.default.Types.ObjectId(req.params.id),
                isDeleted: false,
            });
            if (!notification) {
                return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.NotFound, api_response_1.messages.notification.notificationNotFound);
            }
            return (0, common_service_1.sendDataResponse)(req, res, api_response_1.StatusCode.Ok, api_response_1.messages.success, notification);
        }
        catch (error) {
            logger_service_1.logger.error(`Getting error while notification by id : ${error}`);
            console.log("Getting error while notification by id : ", error);
            return (0, common_service_1.sendMessageResponse)(req, res, api_response_1.StatusCode.InternalServerError, api_response_1.messages.internalServerError);
        }
    });
}
//============== GET NOTIFICATIONS [ SOCKET ] =================//
const getNotificationSocket = (socket, userSocketMap, isAdminUserMap, userId) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        let socketId = userSocketMap[userId];
        let isAdmin = isAdminUserMap[userId];
        let query = {};
        if (isAdmin === false || isAdmin === "false") {
            query = {
                isDeleted: false,
                userId: new mongoose_1.default.Types.ObjectId(userId),
            };
        }
        let notification = yield allUsersNotification_entity_1.default.aggregate([
            {
                $match: query,
            },
            {
                $lookup: {
                    from: "notifications",
                    localField: "notificationId",
                    foreignField: "_id",
                    as: "notificationData",
                },
            },
            {
                $unwind: {
                    path: "$notificationData",
                    preserveNullAndEmptyArrays: true,
                },
            },
            {
                $sort: {
                    createdAt: -1,
                },
            },
        ]);
        socket.to(socketId).emit("get-notification-list", notification);
    }
    catch (error) {
        logger_service_1.logger.error(`Getting error while get notification socket:: ${error}`);
        console.log("Error while get notification socket::", error);
    }
});
exports.getNotificationSocket = getNotificationSocket;
