"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const auth_1 = require("../auth/controlllers/auth");
const upload_1 = require("../middleware/upload");
const auth_2 = require("../middleware/auth");
const file_validator_1 = require("../validators/file.validator");
const auth_validator_1 = require("../validators/auth.validator");
const authRoute = express_1.default.Router();
authRoute.post("/auth/sign-in", auth_1.signIn);
authRoute.post("/auth/sign-up", upload_1.userImage.fields([{ name: "profileImage", maxCount: 1 }]), file_validator_1.validateFile, auth_validator_1.validateAppUser, auth_1.signUp);
authRoute.post("/auth/verifyOTP", auth_1.verifyOTP);
authRoute.post("/auth/googleAuth", auth_1.googleAuth);
authRoute.post("/auth/resend-otp", auth_1.resendOTP);
authRoute.post("/auth/forgot-password", auth_1.resendOTP);
authRoute.post("/auth/reset-password", auth_1.resetPassword);
authRoute.post("/auth/change-password", auth_2.verifyToken, auth_1.changePassword);
authRoute.post("/auth/logout", auth_2.verifyToken, auth_1.logOut);
exports.default = authRoute;
