"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const auth_1 = require("../middleware/auth");
const faqs_1 = require("../faqs/controllers/faqs");
const faqs_validator_1 = require("../validators/faqs.validator");
const checkPermission_1 = require("../middleware/checkPermission");
const faqsRoute = express_1.default.Router();
faqsRoute.post("/add-faq", auth_1.verifyToken, faqs_validator_1.validateFaqs, (0, checkPermission_1.checkPermission)("FAQs", "isAdd"), faqs_1.addFaqs);
faqsRoute.patch("/faq", auth_1.verifyToken, faqs_validator_1.validateFaqs, (0, checkPermission_1.checkPermission)("FAQs", "isEdit"), faqs_1.updateFaqs);
// Removed verifyToken & check permission as guest member can also access this
faqsRoute.get("/faqs", 
//  verifyToken,
//  checkPermission("FAQs", "isView"),
faqs_1.getFaqs);
faqsRoute.delete("/faq/:id", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("FAQs", "isDelete"), faqs_1.deleteFaqs);
faqsRoute.get("/faq/:id", auth_1.verifyToken, (0, checkPermission_1.checkPermission)("FAQs", "isView"), faqs_1.getFaqsById);
exports.default = faqsRoute;
