"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendEmail = sendEmail;
const nodemailer_1 = __importDefault(require("nodemailer"));
const logger_service_1 = require("./logger.service");
function sendEmail(_a) {
    return __awaiter(this, arguments, void 0, function* ({ userEmail, subject, text, html, }) {
        try {
            let transporter = nodemailer_1.default.createTransport({
                host: process.env.SENDGRID_HOST,
                port: Number(process.env.SENDGRID_PORT),
                secure: false, // true for 465, false for other ports
                auth: {
                    user: process.env.SENDER_EMAIL,
                    pass: process.env.SENDGRID_SECRET_KEY,
                },
            });
            const response = yield transporter.sendMail({
                from: process.env.SENDER_EMAIL, // sender address
                to: userEmail, // list of receivers
                subject: subject, // Subject line
                text: text, // plain text body
                html: html, // html body
            });
            return response ? true : false;
        }
        catch (err) {
            console.log("Getting error while sending email:", err);
            logger_service_1.logger.error(`Getting error while sending email: ${err}`);
            return false;
        }
    });
}
