"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.socketSetUp = exports.isAdminUserMap = exports.userSocketMap = void 0;
const notification_1 = require("../notification/controllers/notification");
const workspace_1 = require("../workspace/controllers/workspace");
exports.userSocketMap = {};
exports.isAdminUserMap = {};
const { Server } = require("socket.io");
//************************* SOCKET SERVER SET UP ****************************//
const socketSetUp = (server) => {
    try {
        //======== CONNECTION TO THE SOCKET
        server.on("connection", (socket) => __awaiter(void 0, void 0, void 0, function* () {
            var _a;
            console.log("New user connected.");
            const userId = (_a = socket.handshake.query.userId) === null || _a === void 0 ? void 0 : _a.toString();
            if (!userId ||
                userId == null ||
                userId == undefined ||
                userId == "" ||
                userId === "null" ||
                userId == "undefined") {
                return;
            }
            let isAdmin = false;
            if (typeof socket.handshake.query.isAdmin === "string") {
                isAdmin = JSON.parse(socket.handshake.query.isAdmin);
            }
            exports.isAdminUserMap[userId] = socket.handshake.query.isAdmin;
            exports.userSocketMap[userId] = socket.id;
            //======== GET NOTIFICATION LIST
            socket.on("get-notification-list", () => {
                console.log("get notification list event fired");
                (0, notification_1.getNotificationSocket)(server, exports.userSocketMap, exports.isAdminUserMap, userId);
            });
            //=========== GET WORKSPACE LIST
            socket.on("get-workspace-list", () => {
                console.log("Get workspace list event fired");
                (0, workspace_1.getWorkspaceSocket)(server, exports.userSocketMap, exports.isAdminUserMap, userId);
            });
            //=========== DISCLOSE SOCKET CONNECTION
            socket.on("disconnect", () => {
                delete exports.userSocketMap[userId];
                console.log("User disconnected.");
                return;
            });
        }));
    }
    catch (error) {
        console.log("Error while socket set up::", error);
    }
};
exports.socketSetUp = socketSetUp;
